% ------------------------------------------------------------------------
% Script: infile_1d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 1D P-N model
% ------------------------------------------------------------------------

    % % System name
 
    system='1D P-N model';
 
    % % The absolute path to save the result files
 
    filepath=pwd;
 
    % % The dimension of P-N model: 1 or 2
 
    misdim=1;
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';
    
    % % The data of GSFE (unit: J/m2) and normalized disregistry vector (unit:1)
    
    Ux=[0
0.05184
0.10015
0.1519
0.19773
0.24947
0.30008
0.35201
0.40128
0.45188
0.50134
0.55079
0.6014
0.65085
0.70031
0.75091
0.80018
0.84963
0.89794
0.95084
1];
    SFE=[0
0.14528
0.53118
1.05073
1.58621
2.04469
2.42439
2.69257
2.905
3.01652
3.05015
3.01652
2.89969
2.69789
2.41908
2.05
1.58621
1.05073
0.53649
0.14528
0];
    
    % % Which trial function of disregistry vector to employ (>=1)
    
    Nmis=6;
       
    % % Considering the first-order approximation in the trial function of disregistry
    %   vector (1) or NOT (0)
    
    mis_1st=0;
    
    % % The value of Burgers Vector (unit: A)
 
    BurVect=5.571;
    
    % % The values of shear modulus (unit: GPa) and Poisson's ratio (unit: 1)
 
    shear_modulus=109.25;
    poisson_ratio=0.2439;
    
    % % The dislocation type: edge ('e') or screw ('s')

    mistype='s';
    
    % % Which GSFE fitting function to employ (>=0)
    
    fitcut=3;
    
    % % Matrix of the lower and upper bounds, and initial values of each unknown 
    %   variable ([Lower bound, Upper bound, StartPoint]) 
    
    Xcoef_range=[  0.0000,  1.0000,  0.1667];
    Xdist_range=[-10.0000, 10.0000,  2.0000];
    Xwid_range =[  0.0000,  5.0000,  0.2000];
    Xalpha_range=[ 0.0000,  2.0000,  1.0000];
    
    % % The mothed for fitting the restoring force: "1d_fitting_toolbox" or "1d_lsq_curvefit"
    
    fitmethod='1d_fitting_toolbox';
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------
 
    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='TRUE';
 
    % % The method to calculate the Peierls stress: 1 or 2
    
    pnstrmethod=2;
 
    % % Interplanar distance ?x (unit: A) 

    Inpas=5.571;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field around dislocation core
% ------------------------------------------------------------------------
 
    % % Calculating the pressure field around dislocation core ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='FALSE';
    
    % % The lattice matrix for pressure field
    
    % pressfld_latxz=[];
    % pressfld_latyy=[];
